'''
The parser --tau controls the amount of compression, the bigger the more the model is compressed.
For completeness, we included all the test cases that are displayed in the manuscript. 
Please note that training VGG has a higher computational footprint, especially the baseline model and our proposal for low compression ratios. 
To test our method locally on a laptop (even without GPU support), we suggest the Lenet5 MNIST test case.
To test the method on Cifar10, we remind to uncomment the corresponding lines below.
'''

for CV_RUN in 1 #2 3 4 5
do  
    echo "CV RUN: $CV_RUN"
    ############## LENET MNIST
    python3 ../main.py --baseline 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.0
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.1   
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.15
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.2
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.3


    ############## LENET  FASHION_MNIST
    python3 ../main.py --baseline 1 --save_progress 1 --save_weights 1 --tau 0.0 --cv_run  $CV_RUN --dataset_name 'fashion_mnist'
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.1 --dataset_name 'fashion_mnist'
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.15 --dataset_name 'fashion_mnist'
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.2 --dataset_name 'fashion_mnist'
    python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --save_weights 1 --cv_run $CV_RUN --tau 0.3 --dataset_name 'fashion_mnist'


    ############## ALEXNET  CIFAR10
    # python3 ../main.py --save_progress 1 --net_name 'alexnet' --save_weights 1 --baseline 1 --cv_run $CV_RUN --dataset_name 'cifar10' --tau 0.0
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'alexnet' --save_weights 1 --cv_run $CV_RUN --tau 0.05 --dataset_name 'cifar10'
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'alexnet' --save_weights 1 --cv_run $CV_RUN --tau 0.06 --dataset_name 'cifar10'
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'alexnet' --save_weights 1 --cv_run $CV_RUN --tau 0.08 --dataset_name 'cifar10'
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'alexnet' --save_weights 1 --cv_run $CV_RUN --tau 0.1 --dataset_name 'cifar10'


    # ############## VGG16  CIFAR10
    # python3 ../main.py --save_progress 1 --net_name 'vgg16' --save_weights 1 --baseline 1 --cv_run $CV_RUN --dataset_name 'cifar10' --tau 0.0
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'vgg16' --save_weights 1 --cv_run $CV_RUN --tau 0.03 --dataset_name 'cifar10'
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'vgg16' --save_weights 1 --cv_run $CV_RUN --tau 0.04 --dataset_name 'cifar10'
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'vgg16' --save_weights 1 --cv_run $CV_RUN --tau 0.05 --dataset_name 'cifar10'
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'vgg16' --save_weights 1 --cv_run $CV_RUN --tau 0.08 --dataset_name 'cifar10'
    # python3 ../main.py --adaptive 1 --tucker 1 --save_progress 1 --net_name 'vgg16' --save_weights 1 --cv_run $CV_RUN --tau 0.1  --dataset_name 'cifar10'
  
done
